require "/interface/sexbound/sexui/submodule.lua"

SexUI.POV.Modules.Main = {}
SexUI.POV.Modules.Main_mt = {
    __index = SexUI.POV.Modules.Main
}

require "/interface/sexbound/sexui/submodule/pov/part.lua"

--- Instantiates a new instance
-- @param parant the parent instance
-- @param config a table of config options
function SexUI.POV.Modules.Main.new(parent, config)
    local self = setmetatable({
        _parent = parent,
        _config = config,
        --[[actor1HandLVariantIndex = 1,        -- HANDS! FINGERS! WATCH OUT FOR THOSE WRIST-ROCKETS!
        actor1HandRVariantIndex = 1,
        actor1HandVariantTimer = 0,
        actor1HandVariantChangeTimeout = 0,]]
        animationCycle = config.animationCycle or 1,
        animationTimer = 0,
        frameCount = config.frameCount or 5,
        frameIndex = 1,
        frameName = "",
        parts = {},
        penetrationType = 1
    }, SexUI.POV.Modules.Main_mt)
    
    self.canvas = widget.bindCanvas("pov")
    self.controls = widget.bindCanvas("povControls");
    return self
end

--- Returns if this modules has anything to render
function SexUI.POV.Modules.Main:isAvailable()
    return not isEmpty(self.parts)
end

--- Renders the animation parts managed by this instance
function SexUI.POV.Modules.Main:render(canvas)
    -- If the mod can't find art for any actor, give up.
    if isEmpty(self.parts) then
        return
    end
    
    -- Acquire the ID of the position
    local frame = self.frameName .. "." .. self.frameIndex 
    
    if (self.parts.actor1Body and self.parts.actor1Body:checkImageExists() and self.parts.actor2Body and self.parts.actor2Body:checkImageExists()) then
        -- For Standing, Doggy and Fellatio, layer Actor 2's body over their genitals, and the partner's genitals.
        if (self.frameName == "position1" or self.frameName == "position1-climax" or
            self.frameName == "position2" or self.frameName == "position2-climax") then
            canvas:drawImage(self._config.backgroundImage, {0, 0}, 1.0, "white", false)
            self.parts.actor2Genital:render(canvas, frame)
            self.parts.actor1Body:render(canvas, frame)
            self.parts.actor1Genital:render(canvas, frame)
            self.parts.actor2Body:render(canvas, frame)
            -- self.parts.actor1LHand:render(canvas, frame)    -- Hands are disabled due to lack of compatiblity
            -- self.parts.actor1RHand:render(canvas, frame)    -- and generally covering the action.
            self.parts.actor1BodyOverlay:render(canvas, frame)
            canvas:drawImage(self._config.foregroundImage, {0, 0}, 1.0, self._config.foregroundImageColor, false)
    
        elseif (self.frameName == "position6" or self.frameName == "position6-climax" or 
            self.frameName == "position5" or self.frameName == "position5-climax") then
            canvas:drawImage(self._config.backgroundImage, {0, 0}, 1.0, "white", false)
            self.parts.actor2Back:render(canvas, frame)        -- The back layer was added because of possible gaps in the animation.
            self.parts.actor1Genital:render(canvas, frame)     -- As such, it is not necessary, optional.
            self.parts.actor2Body:render(canvas, frame)
            self.parts.actor2Genital:render(canvas, frame)     -- Genital display during fellatio may not sound useful, but can display pregnancy.
            self.parts.actor2Hair:render(canvas, frame)        -- custom hair render.
            self.parts.actor1Body:render(canvas, frame)
            -- self.parts.actor1LHand:render(canvas, frame)    -- Hands are disabled due to lack of compatiblity
            -- self.parts.actor1RHand:render(canvas, frame)    -- and generally covering the action.
            self.parts.actor1BodyOverlay:render(canvas, frame)
            canvas:drawImage(self._config.foregroundImage, {0, 0}, 1.0, self._config.foregroundImageColor, false)
            
        else
            -- For all others, layer Actor 2's body under their genitals, and above the partner's genitals.  
            canvas:drawImage(self._config.backgroundImage, {0, 0}, 1.0, "white", false)
            self.parts.actor2Back:render(canvas, frame)        -- The back layer was added because of possible gaps in the animation.
            self.parts.actor1Genital:render(canvas, frame)     -- As such, it is not necessary, optional.
            self.parts.actor2Body:render(canvas, frame)
            self.parts.actor1Body:render(canvas, frame)
            self.parts.actor2Genital:render(canvas, frame)
            -- self.parts.actor1LHand:render(canvas, frame)    -- Hands are disabled due to lack of compatiblity
            -- self.parts.actor1RHand:render(canvas, frame)    -- and generally covering the action.
            self.parts.actor1BodyOverlay:render(canvas, frame)
            canvas:drawImage(self._config.foregroundImage, {0, 0}, 1.0, self._config.foregroundImageColor, false)
        end
    end
end

--- Updates this instance
-- @param dt
function SexUI.POV.Modules.Main:update(dt)
    self.animationTimer = self.animationTimer + dt

    local cycle = self.animationCycle / self:getAnimationRate()
    self.frameIndex = util.clamp(math.ceil(self.animationTimer / cycle * self.frameCount), 1, self.frameCount)
    -- This will most likely be removed later (Narrator: And it indeed was)
    --[[self.actor1HandVariantTimer = self.actor1HandVariantTimer + dt              
        
        if (self.actor1HandVariantTimer >= self.actor1HandVariantChangeTimeout) then
            self.actor1HandLVariantIndex = math.random(1, 2)
            self.actor1HandRVariantIndex = math.random(1, 2)
            if (self.actor1HandLVariantIndex == self.actor1HandRVariantIndex) then
                self.actor1HandRVariantIndex = 1
            end
            self.actor1HandVariantTimer = 0
            self.actor1HandVariantChangeTimeout = math.max(15, math.random(60))
        end]]
    
    if (self.animationTimer >= cycle) then
        self.animationTimer = 0
    end
end

function SexUI.POV.Modules.Main:triggerUpdate(actors)
    self:updateParts(actors)
end

--- Updates animation parts for each actor
-- @param a table of actors
function SexUI.POV.Modules.Main:updateParts(actors)
    self.parts = {}
    self.partDirectives = {}

    if isEmpty(actors or {}) or #actors <= 1 then
        return
    end

    self:updatePenetrationType(actors)
    self:updatePartsForActor1(actors[1])
    self:updatePartsForActor2(actors[2])

    if not self.parts.actor1Body:checkImageExists() or not self.parts.actor2Body:checkImageExists() then
        self.parts = {}
        self.partDirectives = {}
        self.frameName = ""
        return
    end

    self.frameName = actors[1].frameName
end

--- Updates animation parts for Actor1
-- @param actor an actor table
function SexUI.POV.Modules.Main:updatePartsForActor1(actor)
    self.parts.actor1Body = SexUI.POV.Part.new(actor, "body")
    self.parts.actor1BodyOverlay = SexUI.POV.Part.new(actor, "body_overlay")
    --self.parts.actor1LHand = SexUI.POV.Part.new(actor, "hand_l_variant" .. self.actor1HandLVariantIndex)
    --self.parts.actor1RHand = SexUI.POV.Part.new(actor, "hand_r_variant" .. self.actor1HandRVariantIndex)

    self.parts.actor1Genital = SexUI.POV.Part.new(actor, "genital")
end

--- Updates animation parts for Actor 2
-- @param actor an actor table
function SexUI.POV.Modules.Main:updatePartsForActor2(actor)
    self.parts.actor2Body = SexUI.POV.Part.new(actor, "body_penetration" .. self.penetrationType)
    self.parts.actor2Back = SexUI.POV.Part.new(actor, "back")
    self.parts.actor2Genital = SexUI.POV.Part.new(actor, "genital")
    self.parts.actor2Hair = SexUI.POV.Part.new(actor, "hair")
    if not self.parts.actor2Hair:checkImageExists() then
        self.parts.actor2Hair = SexUI.POV.Part.newHair(actor, "hair", true)
    end
end

--- Updates the penetration type according to the genital type of actor 1 and 2
-- @param actors a table of actors
function SexUI.POV.Modules.Main:updatePenetrationType(actors)
    local actor1Gender = actors[1].subGender or actors[1].gender or "male"
    local actor2Gender = actors[2].subGender or actors[2].gender or "male"

    -- genital type 0 = male; genital type 1 = female
    if (actor1Gender == "female" or actor1Gender == "cuntboy") then
        self.penetrationType = 1
        return
    end
    if (actor1Gender == "male" or actor1Gender == "futanari") and (actor2Gender == "female" or actor2Gender == "cuntboy" or actor2Gender == "futanari") then
        self.penetrationType = 2
        return
    end
    if (actor1Gender == "male" or actor1Gender == "futanari") and actor2Gender == "male" then
        self.penetrationType = 3
        return
    end
    self.penetrationType = 1
end

--- Sets animation rate to the specified value
-- @param animationRate a decimal number
function SexUI.POV.Modules.Main:getAnimationRate()
    return self._parent.animationRate
end

--- Returns a reference to the UI canvas
function SexUI.POV.Modules.Main:getCanvas()
    return self._parent.canvas
end
